VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   9075
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   9210
   LinkTopic       =   "Form1"
   ScaleHeight     =   9075
   ScaleWidth      =   9210
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkBackgroundPattern 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Show Checker-Pattern"
      Height          =   315
      Left            =   270
      TabIndex        =   1
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   2055
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   -30
      TabIndex        =   0
      Top             =   0
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private WithEvents sldJPGQuality As cSimpleSlider
Attribute sldJPGQuality.VB_VarHelpID = -1

Private PngSource_Bytes() As Byte, PngSrf As cCairoSurface
Private Alpha_JPG_Bytes() As Byte, JPGSrf As cCairoSurface

Private Sub Form_Load()
  Caption = "Alpha-JPG transcoding from Png-Content"
  Me.ScaleMode = vbPixels
  
  'we open the Test.png as a ByteArray, to demonstrate at this occassion,
  'how Surface-Loading from a ByteStream can be accomplished, but also to
  'be able to compare better with the similarly defined AlphaJPG-Variables (and their ByteSize)
  Open App.Path & "\Test.png" For Binary Access Read As 1
    ReDim PngSource_Bytes(0 To LOF(1) - 1)
    Get 1, , PngSource_Bytes
  Close 1
  
  'Now we fill a Surface from the just retrieved ByteArray (so, you can feed image-bytes also from http-streams or whatever directly to the CreateSurface-Call...)
  Set PngSrf = Cairo.CreateSurface(0, 0, ImageSurface, PngSource_Bytes) '<-- that's it already
  
  'Now the JPG-Quality-Slider-Init (this causes already our first ValueChanged-Event farther below,
  'in which we proceed with the AlphaJPG-conversion from the Png-Surface and then compare sizes)
  Set sldJPGQuality = New cSimpleSlider
  sldJPGQuality.Init ucCanvas1.Controlpoints, 30, 555, 555, 28, 70, 98, 80
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub chkBackgroundPattern_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub sldJPGQuality_ValueChanged(ByVal NewValue As Double)
  sldJPGQuality.Caption = "JPG-Quality: " & CLng(NewValue)

  PngSrf.WriteContentToJpgByteArray Alpha_JPG_Bytes, NewValue, True   '<-- that was it already, ...
  
  'we just created an AlphaJPG-encoded ByteStream within the Alpha_JPG_Bytes()-Array
  'which one now could write to disk ... or send over sockets ... we proceed further
  'with these Bytes by creating a new JPGSrf from them, which will be rendered
  'within our Refresh-Routine below...
  
  Set JPGSrf = Cairo.CreateSurface(0, 0, ImageSurface, Alpha_JPG_Bytes)
End Sub

Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim CheckerPat As cCairoPattern, S As String

  'this time we fill the Surface with a checker-pattern (to better demonstrate the transparency-areas of the Alpha-Images)
  CC.PushGroup CAIRO_CONTENT_COLOR_ALPHA, 0, 0, 20, 20
    CC.SetSourceColor vbWhite
    CC.Paint 'up to this point, we only filled the 20x20 Pattern on our "CC-stack" with plain white
    
    'what remains, are two 10x10 rectangles (diagonally placed and filled with grey)
    'but we make this dependent on the appropriate CheckBox-Value on the Form
    If chkBackgroundPattern.Value Then
      CC.Rectangle 0, 0, 10, 10
      CC.Rectangle 10, 10, 10, 10
        CC.SetSourceColor &HE8E8E8 'a ligth-grey
      CC.Fill
    End If
  CC.SetSourcePattern CC.PopGroup(True, CAIRO_EXTEND_REPEAT)    'this pops up our 20x20 Pattern from the stack - the True-Param ensures, that the clipped Pattern-Region is reset, ...
  CC.Paint '...and CAIRO_EXTEND_REPEAT will ensure, that we fill the whole Surface with it now in our Paint-Method
  
  
  'this renders the two different surfaces, the JPGSrf usually just updated with fresh recalculated "JPG-Bytes"
  CC.RenderSurfaceContent PngSrf, 20, 30
  CC.RenderSurfaceContent JPGSrf, 20, 250
  
  
  'here we render the larger TextComment within a rounded rect - this demonstrates the usage of the CC.DrawText-Method
  CC.Save
    CC.TranslateDrawings 30.5, 470.5
    CC.RoundedRect 0, 0, 555, 75, 8, True
      CC.SetLineWidth 0.9
      CC.SetSourceColor &H808090, 0.75
    CC.Stroke

    S = "The Top-Row with the three Image-parts is rendered from Png-Content - the Image-Row directly above this text is the same Alpha-Content, but " & _
        "encoded in a JPG-Stream. Just use the Slider below, to compare visually with which quality you could live, deploying your Alpha-Resources..." & vbCrLf & vbCrLf & _
        "PngStream-Bytes: " & UBound(PngSource_Bytes) + 1 & _
        ", JpgStream-Bytes: " & UBound(Alpha_JPG_Bytes) + 1 & _
        ", Ratio " & Format((UBound(PngSource_Bytes) + 1) / (UBound(Alpha_JPG_Bytes) + 1), "0.0")

    CC.SelectFont "Tahoma", 8.5, &H485858
    CC.DrawText 12, 5, 540, 70, S
  CC.Restore
  
  
  'finally we redraw our slider-control too
  sldJPGQuality.Draw CC
  
  ucCanvas1.Refresh
End Sub
